/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.fluid;

import cofh.core.render.IconRegistry;
import cofh.lib.render.particle.EntityDropParticleFX;
import cofh.lib.util.helpers.StringHelper;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;

public abstract class BlockFluidCoFHBase
extends BlockFluidClassic {
    String name = "";
    String modName = "cofh";
    protected float particleRed = 1.0f;
    protected float particleGreen = 1.0f;
    protected float particleBlue = 1.0f;
    protected boolean shouldDisplaceFluids = false;

    public BlockFluidCoFHBase(Fluid fluid, Material material, String string) {
        super(fluid, material);
        this.name = StringHelper.titleCase(string);
        this.setRenderPass(1);
        this.setBlockName(this.modName + ".fluid." + string);
        this.displacements.put(this, false);
    }

    public BlockFluidCoFHBase(String string, Fluid fluid, Material material, String string2) {
        super(fluid, material);
        this.name = StringHelper.titleCase(string2);
        this.modName = string;
        this.setRenderPass(1);
        this.setBlockName(string + ".fluid." + string2);
        this.displacements.put(this, false);
    }

    public BlockFluidCoFHBase setParticleColor(int n) {
        return this.setParticleColor((float)(n >> 16 & 0xFF) / 255.0f, (float)(n >> 8 & 0xFF) / 255.0f, (float)(n >> 0 & 0xFF) / 255.0f);
    }

    public BlockFluidCoFHBase setParticleColor(float f, float f2, float f3) {
        this.particleRed = f;
        this.particleGreen = f2;
        this.particleBlue = f3;
        return this;
    }

    public BlockFluidCoFHBase setDisplaceFluids(boolean bl) {
        this.shouldDisplaceFluids = bl;
        return this;
    }

    public boolean canCreatureSpawn(EnumCreatureType enumCreatureType, IBlockAccess iBlockAccess, int n, int n2, int n3) {
        return false;
    }

    public boolean preInit() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int n, int n2) {
        return n <= 1 ? IconRegistry.getIcon("Fluid" + this.name) : IconRegistry.getIcon("Fluid" + this.name, 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iIconRegister) {
        IconRegistry.addIcon("Fluid" + this.name, this.modName + ":fluid/Fluid_" + this.name + "_Still", iIconRegister);
        IconRegistry.addIcon("Fluid" + this.name + "1", this.modName + ":fluid/Fluid_" + this.name + "_Flow", iIconRegister);
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int n, int n2, int n3, Random random) {
        super.randomDisplayTick(world, n, n2, n3, random);
        double d = (float)n + random.nextFloat();
        double d2 = (double)n2 - 1.05;
        double d3 = (float)n3 + random.nextFloat();
        if (this.density < 0) {
            d2 = (double)n2 + 2.1;
        }
        if (random.nextInt(20) == 0 && world.isSideSolid(n, n2 + this.densityDir, n3, this.densityDir == -1 ? ForgeDirection.UP : ForgeDirection.DOWN) && !world.getBlock(n, n2 + 2 * this.densityDir, n3).getMaterial().blocksMovement()) {
            EntityDropParticleFX entityDropParticleFX = new EntityDropParticleFX(world, d, d2, d3, this.particleRed, this.particleGreen, this.particleBlue, this.densityDir);
            FMLClientHandler.instance().getClient().effectRenderer.addEffect((EntityFX)entityDropParticleFX);
        }
    }

    public boolean canDisplace(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        if (!this.shouldDisplaceFluids && iBlockAccess.getBlock(n, n2, n3).getMaterial().isLiquid()) {
            return false;
        }
        return super.canDisplace(iBlockAccess, n, n2, n3);
    }

    public boolean displaceIfPossible(World world, int n, int n2, int n3) {
        if (!this.shouldDisplaceFluids && world.getBlock(n, n2, n3).getMaterial().isLiquid()) {
            return false;
        }
        return super.displaceIfPossible(world, n, n2, n3);
    }
}

